<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
package ${pub.getPKGCodeName()}.core.util.config;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import ${pub.getPKGCodeName()}.util.helper.UniqueNameGenerator;

import com.baomidou.mybatisplus.core.injector.ISqlInjector;
<#--import com.baomidou.mybatisplus.extension.injector.LogicSqlInjector;-->
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.optimize.JsqlParserCountOptimize;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.mybatis.spring.annotation.MapperScan;
import java.util.Properties;
<#if sys.getSaaSMode()==1>
import cn.ibizlab.resourcescheduling.util.security.AuthenticationUser;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantSqlParser;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import java.util.ArrayList;
import java.util.List;
</#if>

/**
 * mybatis全局配置类
 */
@Configuration
@MapperScan(value="${pub.getPKGCodeName()}.core.*.mapper",nameGenerator = UniqueNameGenerator.class)
public class MybatisConfiguration {

    /**
     * mybatis适配多数据库
     * @return
     */
    @Bean
    public DatabaseIdProvider getDatabaseIdProvider() {
        DatabaseIdProvider databaseIdProvider = new VendorDatabaseIdProvider();
        Properties p = new Properties();
        p.setProperty("Oracle", "oracle");
        p.setProperty("MySQL", "mysql");
        p.setProperty("PostgreSQL", "postgresql");
        p.setProperty("DM", "oracle");//达梦数据库使用oracle模式
        p.setProperty("H2", "mysql");//根据当前运行的数据库设置h2对应的databaseid
        databaseIdProvider.setProperties(p);
        return databaseIdProvider;
    }

    /**
     * mybatis-plus分页
     * @return
     */
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        // 设置请求的页面大于最大页后操作， true调回到首页，false 继续请求  默认false
        // paginationInterceptor.setOverflow(false);
        // 设置最大单页限制数量，默认 500 条，-1 不受限制
        paginationInterceptor.setLimit(-1);
<#if sys.getSaaSMode()==1>

        // 创建SQL解析器集合
        List<ISqlParser> sqlParserList = new ArrayList<>();
        // 创建租户SQL解析器
        TenantSqlParser tenantSqlParser = new TenantSqlParser();

        // 设置租户处理器
        tenantSqlParser.setTenantHandler(new TenantHandler() {

            @Override
            public Expression getTenantId(boolean where) {
                AuthenticationUser user = AuthenticationUser.getAuthenticationUser();
                return new StringValue(user.getDomain());
            }

            @Override
            public String getTenantIdColumn() {
                return "SRFDCID";
            }

            @Override
            public boolean doTableFilter(String tableName) {
                return false;
            }
        });

        sqlParserList.add(tenantSqlParser);
        paginationInterceptor.setSqlParserList(sqlParserList);
</#if>        

        // 开启 count 的 join 优化,只针对部分 left join
        paginationInterceptor.setCountSqlParser(new JsqlParserCountOptimize(true));
        return paginationInterceptor;
    }

    <#--/**-->
     <#--* mybatis-plus逻辑有效-->
     <#--* @return-->
     <#--*/-->
    <#--@Bean-->
    <#--public ISqlInjector sqlInjector() {-->
        <#--return new LogicSqlInjector();-->
    <#--}-->
}